/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.feature.template.IPosRuleTests;
import net.minecraft.world.gen.feature.template.PosRuleTest;

public class PieceOriginAxisAlignedLinearPosRuleTest
extends PosRuleTest {
    public static final Codec<PieceOriginAxisAlignedLinearPosRuleTest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(ruleTest -> Float.valueOf(ruleTest.minChance)), (App)Codec.FLOAT.fieldOf("max_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(ruleTest -> Float.valueOf(ruleTest.maxChance)), (App)Codec.INT.fieldOf("min_dist").orElse((Object)0).forGetter(ruleTest -> ruleTest.minDistance), (App)Codec.INT.fieldOf("max_dist").orElse((Object)0).forGetter(ruleTest -> ruleTest.maxDistance), (App)Direction.Axis.field_239632_d_.fieldOf("axis").orElse((Object)Direction.Axis.Y).forGetter(ruleTest -> ruleTest.axis)).apply((Applicative)instance, PieceOriginAxisAlignedLinearPosRuleTest::new));
    private final float minChance;
    private final float maxChance;
    private final int minDistance;
    private final int maxDistance;
    private final Direction.Axis axis;

    public PieceOriginAxisAlignedLinearPosRuleTest(float minChance, float maxChance, int minDistance, int maxDistance, Direction.Axis axis) {
        if (minDistance >= maxDistance) {
            throw new IllegalArgumentException("Invalid range: [" + minDistance + "," + maxDistance + "]");
        }
        this.minChance = minChance;
        this.maxChance = maxChance;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.axis = axis;
    }

    public boolean func_230385_a_(BlockPos blockPos, BlockPos blockPos2, BlockPos blockPos3, Random random) {
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis);
        float xDist = Math.abs(blockPos.func_177958_n() * direction.func_82601_c());
        float yDist = Math.abs(blockPos.func_177956_o() * direction.func_96559_d());
        float zDist = Math.abs(blockPos.func_177952_p() * direction.func_82599_e());
        int distanceFromOrigin = (int)(xDist + yDist + zDist);
        float randomChance = random.nextFloat();
        return (double)randomChance <= MathHelper.func_151238_b((double)this.minChance, (double)this.maxChance, (double)MathHelper.func_233020_c_((double)distanceFromOrigin, (double)this.minDistance, (double)this.maxDistance));
    }

    protected IPosRuleTests<?> func_230384_a_() {
        return RSPredicates.PIECE_ORIGIN_AXIS_ALIGNED_LINEAR_POS_RULE_TEST;
    }
}

